<?xml version="1.0" encoding="UTF-8"?>
<!--Changes :
    2/2/2005 : retrait de Doc2HTML qui est traité dans le pipeline de la sitemap TestDoc= ajout des balises injacDoc/injacDocRender
-->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:dir="http://apache.org/cocoon/directory/2.0"
	xmlns:collection="http://apache.org/cocoon/collection/1.0"
	
>
	<!--xmlns:text="http://chaperon.sourceforge.net/schema/text/1.0"-->
   	<!--xsl:import href="../docbook-xsl-1.66.1/html/docbook.xsl" /-->
    <xsl:param name ="path" />
	<xsl:param name ="file" />
	<xsl:param name ="doc" />
	<xsl:variable name="filetype" select="substring-after($file, '.')" />
	
	
	
	<xsl:template name="insert-ToPDF-link">
		<div id="iDocToPDF">
			<a href="makepdf{$path}/{$file}.pdf" target="_blank"><img alt="format PDF" height="16" width="16" border="0" src="_images/acrobat.gif" /></a>           
		</div>
	</xsl:template>
	
	<!-- rendu tout document -->	
	<xsl:template match="*">
            <xsl:choose>
			<!-- Documents avec conversion PDF -->
			<xsl:when test="$filetype='txt' or $filetype='xml'">
				<xsl:call-template name="insert-ToPDF-link"/>
				<doc name="{$doc}"/>
				<div id="iDocRender">
				<xsl:copy-of select="."/>
				</div>
			</xsl:when>
                        <xsl:when test="$filetype='html' or $filetype='htm'">
				<xsl:call-template name="insert-ToPDF-link"/>
				<div id="iDocRender">
				<!--xsl:copy-of select="html/body|HTML/BODY|html/frameset|HTML/FRAMESET"/-->
                                <xsl:copy-of select="."/>
				</div>
			</xsl:when>
			<!-- Documents sans conversion PDF -->
			<xsl:when test="$filetype='jpg' or $filetype='gif' or $filetype='png' or $filetype='JPG' or $filetype='GIF' or $filetype='PNG'">
				<div id="iDocRender">
				<img src="res-{substring-after($path, '/')}/{$file}" alt="{$file}"/>
				</div>
			</xsl:when>
                        <xsl:when test="$filetype='java'">
				<xsl:call-template name="insert-ToPDF-link"/>
				<div id="iDocRender">
				<xsl:copy-of select="."/>
				</div>
			</xsl:when>
			<xsl:otherwise>
                                <xsl:call-template name="insert-ToPDF-link"/>
				<div id="iDocRender">
                                <xsl:copy-of select="."/>
				<!--pre><xsl:value-of select="."/></pre-->
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text">
		text
		<xsl:apply-templates />
	</xsl:template>


	<xsl:template match="article">
      		 	<xsl:apply-imports>
					<!--xsl:with-param name="path"><xsl:value-of select="$path" /></xsl:with-param-->
      		 	</xsl:apply-imports>
	</xsl:template> 
	<!-- (deprecated) rendu liens associes  -->
	<xsl:template match="injacRelDocs">
      	<div id="iRelDocs">
		<div class="titre_reldoc">Voir aussi</div>
		
		<ul type="circle">
		<xsl:for-each select="reldocs/reldoc" >
			<li><a href ="{./@path}" ><xsl:value-of select="./@name"/></a></li>
		</xsl:for-each>
		</ul>
	</div>
   	</xsl:template>

</xsl:stylesheet>

